% IR plot
clear all;

load('sampledataT232');
sampledata=sampledataT232;

[d, T, s] = size(sampledata);

global p h;
p = 4;
h = 80;

Nmean = 100;

m_sampleirf = zeros(4, (h+1), Nmean);

for i = 1:Nmean
    v_sampledata = sampledata(:, :, i); 
    [A,SIGMA,U,V] = olsvarc(v_sampledata', p);
    sampleirf = irfvar(A,SIGMA,p);
    m_sampleirf(:,:, i) = sampleirf;
end

irfmean = mean(m_sampleirf, 3);
irf_horizon = 1:h;
plot(irf_horizon, irfmean(:, 2:h+1), 'LineWidth', 1.5)
xlabel('h')
ylabel('IRFs')